/*
 * Lambda calculus in Javascript.
 *
 * Kudos to https://www.youtube.com/watch?v=3VQ382QG-y4 for the idea behind inspect.
 *   also https://matt.might.net/articles/js-church/
 */

// START:identity
I = a => a
// END:identity

// START:m-and-k
M = a => a(a)

K = a => b => a
// END:m-and-k

// Boolean logic

// START:true-and-false
T = a => b => a

F = a => b => b
// END:true-and-false

// START:not
NOT = p => p(F)(T)
// END:not

// START:and-or
AND = p => q => p(q)(p)

OR = p => q => p(p)(q)
// END:and-or

EQ = p => q => p(q)(NOT(q))

// Let's test a bit

console.log("NOT(T)", NOT(T))
console.log("AND(NOT(F))(T)", AND(NOT(F))(T))

// Numbers. Much less instructive, probably scrap this.

// START:zero
ZERO = f => x => x
// END:zero

// START:one-two
ONE = f => x => f(x)

TWO = f => x => f(f(x))
// END:one-two

// START:succ
SUCC = n => f => x => f(n(f)(x))
// END:succ

// START:plus-times
PLUS = m => n => f => x => (m(f)(n(f)(x)))

MULT = m => n => f => x => (m(n(f))(x))
// END:plus-times

// Helpers

// START:convert
church_to_int = c => c((x) => x + 1)(0)
int_to_church =  n =>
    n === 0 ? ZERO : SUCC(int_to_church(n - 1))
// END:convert

// Demo

three = SUCC(TWO)
console.log("3: ", church_to_int(three))
four = int_to_church(4)
console.log("4: ", church_to_int(four))
seven = PLUS(three)(four)
console.log("4 + 3: ", church_to_int(seven))
