// The tape is an infinite array that can extend in both
// directions, all filled with blanks.
//
// machine state consists of the current
// tape position and the internal state.

// START: machine
tape = []

machine = {
  pos: 0,
  state: undefined
}
// END: machine

clean_dump = () => console.log('tape', tape.filter((_,i) => !(i&1)), ', machine', machine)

// START: computer
turing_step = () => {
  state_key = machine.state + '/' + tape[machine.pos]
  any_key = machine.state + '/any'
  action_items = states[state_key] || states[any_key]
  functions = action_items[0]
  next = action_items[1]
  functions.forEach(f => f())
  machine.state = next
}

dump = () => console.log('tape', tape, ', machine', machine)

turing_run = (n) => {
  for (i = 0; i < n; i++) {
    turing_step()
    dump()
  }
}
// END: computer

// START: actions
e =  () => tape[machine.pos] = undefined
p0 = () => tape[machine.pos] = 0
p1 = () => tape[machine.pos] = 1
r =  () => machine.pos++
l =  () => machine.pos--
// END: actions
//

// the most important part is the state transition
// table. Here is one, taken from Turing's paper,
// that writes alternating ones and zeros
// START: zeroes-and-ones
states = {
  'b/any': [[p0, r], 'c'],
  'c/any': [[r], 'e'],
  'e/any': [[p1, r], 'f'],
  'f/any': [[r], 'b']
}

machine.state = 'b'
// END: zeroes-and-ones

// turing_run(5)

// the simplified version where we allow any number of actions.
// START: simpler-zeroes-and-ones
states = {
  'b/undefined': [[p0], 'b'],
  'b/0': [[r,r,p1], 'b'],
  'b/1': [[r,r,p0], 'b']
}
machine.state = 'b'
// END: simpler-zeroes-and-ones
//turing_run(10)

// the next machine defines some more operations
// START: numbers
pe = () => tape[machine.pos] = 'e'
px = () => tape[machine.pos] = 'x'

states = {
  'b/undefined': [[pe, r, pe, r, p0, r, r, p0, l, l], 'o'],
  'o/1': [[r, px, l, l, l], 'o'],
  'o/0': [[], 'q'],
  'q/any': [[r, r], 'q'],
  'q/undefined': [[p1, l], 'p'],
  'p/x': [[e, r], 'q'],
  'p/e': [[r], 'f'],
  'p/undefined': [[l, l], 'p'],
  'f/any': [[r, r], 'f'],
  'f/undefined': [[p0, l, l], 'o']
}
machine.state = 'b'
// END: numbers

turing_run(1200)
clean_dump()
