(defun edebug-untrace (form)
  "Remove tracing instructions from FORM."
  (if (consp form)
      (if (eq (car form) 'edebug-tracing)
          (edebug-untrace (caddr form))
        (cons (edebug-untrace (car form))
              (edebug-untrace (cdr form))))
    form))

(defcustom edebug-trace-print-level 3
  "`print-level' for `edebug-make-trace-form'."
  :type 'integer
  :group 'edebug)

(defcustom edebug-trace-print-length 5
  "`print-length' for `edebug-make-trace-form'."
  :type 'integer
  :group 'edebug)

(defun edebug-make-trace-form (form)
  "Prepare FORM for tracing."
  `(edebug-tracing ,(let ((print-level edebug-trace-print-level)
                          (print-length edebug-trace-print-length))
                      (prin1-to-string (edebug-untrace form)))
                   ,form))

(defun edebug-make-trace-enter-wrapper (forms)
  "Prepare function with FORMS for tracing."
  (if edebug-def-name
      `(edebug-tracing ,(format "%S%S"
                                edebug-def-name
                                (nreverse edebug-def-args))
                       ,@forms)
    `(progn ,@forms)))

(defun edebug-instrument-for-tracing ()
  "Like `edebug-defun' but instruments for tracing."
  (interactive)
  (cl-letf (((symbol-function 'edebug-make-enter-wrapper)
             (lambda (forms)
               (edebug-make-trace-enter-wrapper forms)))
            ((symbol-function 'edebug-make-before-and-after-form)
             (lambda (before-index form after-index)
               (edebug-make-trace-form form)))
            ((symbol-function 'edebug-make-after-form)
             (lambda (form after-index)
               (edebug-make-trace-form form))))
    (edebug-defun)))


(setq lexical-binding nil)
;; From file:///home/cees/SyncthingCees/orgwiki/docs/lisp%20history%20according%20to%20McCarthy.pdf,
;; page 11
(defun dynamic-testr (x p f u)
  (message "Step in with %s" x)
  (if (funcall p x)
      (funcall f x)
    (if (atom x)
        (funcall u)
      (dynamic-testr (cdr x) p f (lambda ()
                                   (message "Right hand %s" x)
                                   (dynamic-testr (car x) p f u))))))

(dynamic-testr
 '(a (b d e) c (f g))
 (lambda (p) (eq 'g p))
 (lambda (f) (message "Found %s" f))
 (lambda () (message "Atom!")))

(provide 'dynamic)
;;; dynamic.el ends here
